<div class="content-wrapper bg-white pt-4">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?= $judul . $kelas['nama_kelas'] ?></h1>
                </div>
                <div class="col-6">
                    <button onclick="window.history.back();" type="button" class="btn btn-sm btn-danger float-right">
                        <i class="fas fa-arrow-circle-left"></i><span
                                class="d-none d-sm-inline-block ml-1">Kembali</span>
                    </button>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="card my-shadow mb-4">
                <div class="card-header py-3">
                    <div class="card-title">
                        <h6><b><?= $mapel['nama_mapel'] ?></b></h6>
                    </div>
                </div>
                <div class="card-body">
                    <?php if ($kkm == null): ?>
                        <div class="alert alert-default-danger align-content-center" role="alert">
                            Download template tidak tersedia, Anda harus mengisi KKM terlebih dahulu di menu <b>DATA
                                RAPOR > KKM DAN BOBOT</b>
                        </div>
                    <?php else: ?>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <a href="<?= base_url('rapor/downloadtemplatepas/' . $mapel['id_mapel'] . '/' . $kelas['id_kelas']) ?>"
                                   id="download" type="button" class="btn btn-primary w-100">
                                    <i class="fa fa-download"></i> <span class="ml-1">Download Template</span>
                                </a>
                            </div>

                            <div class="col-md-8">
                                <?= form_open_multipart('', array('id' => 'uploadpas')); ?>
                                <div class="row">
                                    <div class="col-8">
                                        <div class="custom-file">
                                            <input type="file" name="upload_file" class="custom-file-input"
                                                   id="customFile">
                                            <label class="custom-file-label" for="customFile">Pilih file excel</label>
                                        </div>
                                    </div>

                                    <div class="col-4">
                                        <button id="upload" type="submit" class="btn btn-success w-100">
                                            <i class="fa fa-upload"></i> <span class="ml-1">Upload</span>
                                        </button>
                                    </div>
                                </div>
                                <?= form_close(); ?>
                            </div>
                        </div>
                        <hr>
                        <?php
                        if ($kkm == null) :?>
                            <div class="alert alert-default-warning shadow align-content-center" role="alert">
                                KKM dan Bobot belum diatur
                            </div>
                        <?php endif; ?>
                        <?php
                        $multi = $setting_rapor->kkm_tunggal == "0" ? "MULTI" : "TUNGGAL";
                        $isi = $kkm->kkm;
                        $d = 0;
                        $dsd = $isi - 1;
                        $c = $isi;
                        $csd = floor($isi + (100 - $isi) / 3);
                        $b = $csd + 1;
                        $bsd = floor($b + (100 - $b) / 2);
                        $a = $bsd + 1;
                        $asd = 100;
                        ?>
                        <table class="table w-100 table-bordered border-dark">
                            <tr class="bg-light text-center">
                                <td style="width: 20%">KKM</td>
                                <td style="width: 20%">Jenis KKM</td>
                                <td style="width: 40%">Interval Predikat Berdasarkan KKM</td>
                                <td style="width: 20%">Bobot Nilai PAS</td>
                            </tr>
                            <tr class="text-center text-md text-dark">
                                <td><?= $kkm->kkm ?></td>
                                <td><?= $multi ?></td>
                                <td>
                                    <span class="bg-danger badge p-1">0 ~ <?= $dsd ?> : D</span>
                                    <span class="bg-warning badge p-1"><?= $c . ' ~ ' . $csd ?> : C</span>
                                    <span class="bg-blue badge p-1"><?= $b . ' ~ ' . $bsd ?> : B</span>
                                    <span class="bg-success badge p-1"><?= $a ?> ~ 100 : A</span>
                                </td>
                                <td><?= $kkm->bobot_pas ?> %</td>
                            </tr>
                        </table>
                        <div id="t-siswa" class="w-100"></div>
                        <?= form_open('', array('id' => 'uploadnilai')) ?>
                        <input type="hidden" name="id_kelas" class="form-control" value="<?= $mapel['id_mapel'] ?>">
                        <input type="hidden" name="id_mapel" class="form-control" value="<?= $kelas['id_kelas'] ?>">
                        <div class="row mt-3 mb-3">
                            <div class="col-12 text-right">
                                <button type="submit" class="btn btn-primary mt-3 mb-3">
                                    <i class="fa fa-save mr-1"></i>Simpan
                                </button>
                            </div>
                        </div>
                        <div id="for-upload" class="d-none row"></div>
                        <?= form_close() ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript" src="<?= base_url() ?>/assets/plugins/jexcel/js/jexcel.js"></script>
<script type="text/javascript" src="<?= base_url() ?>/assets/plugins/jexcel/js/jsuites.js"></script>
<script>
    var arrSiswa = JSON.parse(JSON.stringify(<?= json_encode($siswa)?>));
    var arrNilai = JSON.parse(JSON.stringify(<?= json_encode($nilai)?>));
    var kkmGuru = JSON.parse(JSON.stringify(<?= json_encode($kkm)?>));
    var kkmSetting = JSON.parse(JSON.stringify(<?= json_encode($setting_rapor)?>));
    var idMapel = '<?=$mapel['id_mapel']?>';
    var idKelas = '<?=$kelas['id_kelas']?>';
    var tpActive = '<?=$tp_active->id_tp?>';
    var smtActive = '<?=$smt_active->id_smt?>';

    var isi;
    var bobotPH, bobotPTS, bobotPAS;
    if (kkmSetting.kkm_tunggal == '1') {
        isi = parseInt(kkmSetting.kkm);
        bobotPH = parseInt(kkmSetting.bobot_ph);
        bobotPTS = parseInt(kkmSetting.bobot_pts);
        bobotPAS = parseInt(kkmSetting.bobot_pas);
    } else {
        isi = parseInt(kkmGuru.kkm);
        bobotPH = parseInt(kkmGuru.bobot_ph);
        bobotPTS = parseInt(kkmGuru.bobot_pts);
        bobotPAS = parseInt(kkmGuru.bobot_pas);
    }
    var pre_d = 0;
    var pre_dsd = isi - 1;
    var pre_c = isi;
    var pre_csd = Math.floor(isi + (100 - isi) / 3);
    var pre_b = pre_csd + 1;
    var pre_bsd = Math.floor(pre_b + (100 - pre_b) / 2);
    var pre_a = pre_bsd + 1;
    var pre_asd = 100;

    var arrIndic = ["P1", "P2", "P3", "P4", "P5", "P6", "P7", "P8"];
    var cols = [];

    $(function () {
        bsCustomFileInput.init();
    });

    $(document).ready(function () {
        console.log('a:' + pre_a + ' b:' + pre_b + ' bd:' + pre_bsd + ' c:' + pre_c + ' cd:' + pre_csd + ' dd:' + pre_dsd);
        console.log('ph:' + bobotPH + ' PTS:' + bobotPTS + ' pas:' + bobotPAS);
        var dataSiswa = [];
        var row = 1;
        $.each(arrSiswa, function (i, v) {
            var noInduk = v.nisn == null || v.nisn == '' ? v.nis : v.nisn;
            var nilai = arrNilai[v.id_siswa];
            dataSiswa.push(
                [
                    noInduk, v.nama, nilai.nhar, nilai.npts, nilai.npas,
                    '=IFERROR(ROUND((((C' + row + '*' + bobotPH + ')/100)+((D' + row + '*' + bobotPTS + ')/100)+((E' + row + '*' + bobotPAS + ')/100)),0),"")',
                    '=IF(F' + row + '>' + pre_bsd + ',"A",IF(F' + row + '>' + pre_csd + ',"B",IF(F' + row + '>' + pre_dsd + ',"C",IF(F' + row + '<' + pre_c + ',"D",""))))',
                    nilai.p_deskripsi, nilai.k_rata_rata, nilai.k_predikat, nilai.k_deskripsi, v.id_siswa
                ]
            );
            row++;
        });

        var tableSiswa = $('#t-siswa');

        var arrCol = [];

        var pno = 1;
        var kno = 1;
        var char = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        for (let i = 0; i < 12; i++) {
            var item = {};

            if (i === 0) {
                item['title'] = 'NIS/NISN\n' + char.charAt(i);
                item['width'] = 160;
            } else if (i === 1) {
                item['title'] = 'NAMA SISWA\n' + char.charAt(i);
                item['width'] = 250;
            } else if (i === 2) {
                item['title'] = 'RPH\n' + char.charAt(i);
                item['width'] = 50;
                pno++;
            } else if (i === 3) {
                item['title'] = 'PTS\n' + char.charAt(i);
                item['width'] = 50;
            } else if (i === 4) {
                item['title'] = 'PAS\n' + char.charAt(i);
                item['width'] = 50;
            } else if (i === 5) {
                item['title'] = 'AKHIR\n' + char.charAt(i);
                item['width'] = 70;
            } else if (i === 6) {
                item['title'] = 'PRED\n' + char.charAt(i);
                item['width'] = 70;
            } else if (i === 7) {
                item['title'] = 'DESKRIPSI\n' + char.charAt(i);
                item['width'] = 300;
                item['wordWrap'] = true;
            } else if (i === 8) {
                item['title'] = 'NILAI\n' + char.charAt(i);
                item['width'] = 50;
            } else if (i === 9) {
                item['title'] = 'PRED\n' + char.charAt(i);
                item['width'] = 50;
            } else if (i === 10) {
                item['title'] = 'DESKRIPSI\n' + char.charAt(i);
                item['width'] = 300;
                item['wordWrap'] = true;
            } else if (i === 11) {
                item['title'] = 'ID';
                item['width'] = 1;
            }
            item['colspan'] = '1';

            arrCol.push(item);
        }

        tableSiswa.jexcel({
            data: dataSiswa,
            minDimensions: [12],
            //defaultColWidth: 100,
            tableOverflow: true,
            tableWidth: '' + tableSiswa.width() + 'px',
            tableHeight: (80 * dataSiswa.length) + 'px',
            search: true,
            freezeColumns: 2,
            //rowResize: true,
            columnResize: false,
            columns: arrCol,
            /*[
            {width: 100},
            {width: 300},       ],*/
            nestedHeaders: [
                [
                    {
                        title: 'DATA SISWA',
                        colspan: '2',
                    },
                    {
                        title: 'NILAI PENGETAHUAN',
                        colspan: '6',
                    },
                    {
                        title: 'NILAI KETERAMPILAN',
                        colspan: '4',
                    },
                ],
            ],
            updateTable: function (instance, cell, col, row, val, label, cellName) {
                if (col === 0) {
                    cell.className = '';
                    cell.style.backgroundColor = '#f8d7da';
                    cell.style.textAlign = 'center';
                    cell.classList.add('readonly');
                }

                if (col === 1) {
                    cell.className = '';
                    cell.style.backgroundColor = '#f8d7da';
                    cell.style.textAlign = 'left';
                    cell.classList.add('readonly');
                }

                if (col === 4) {
                    cell.style.backgroundColor = '#b9f6ca';
                }


                if (col === 7 || col === 10 || col === 11) {
                    cell.className = '';
                    cell.style.backgroundColor = '#fff3cd';
                    cell.classList.add('readonly');
                    cell.style.fontSize = 'small';
                }

                if (col === 2 || col === 3 || col === 5 || col === 6 || col === 8 || col === 9) {
                    cell.className = '';
                    cell.style.backgroundColor = '#ffebee';
                    cell.classList.add('readonly');
                }

                if (col === 5 || col === 6 || col === 8 || col === 9) {
                    cell.style.fontWeight = '600'
                }
            },
            onchange: function (instance, cell, col, row, value, label) {
                //var cellName = jexcel.getColumnNameFromId([col,row]);
                //console.log(col, cell);
            }
        });

        function cellRef(cel) {
            var x = cel.replace(/[A-Za-z]/g, "");
            x = x.charCodeAt(0) - 65;
            var y = cel.replace(/\D/g, "");
            y = y - 1;

            return x + "," + y;
        }

        $('#uploadpas').submit('click', function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();

            var form = new FormData($('#uploadpas')[0]);

            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: base_url + 'rapor/uploadpas/' + idMapel + '/' + idKelas,
                data: form,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 600000,
                success: function (data) {
                    console.log(data);
                    window.location.href = base_url + 'rapor/inputpas/' + idMapel + '/' + idKelas
                },
                error: function (e) {
                    console.log("error", e.responseText);
                    showDangerToast(e.responseText);
                }
            });
        });

        $('#uploadnilai').on('submit', function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();

            swal.fire({
                title: "Menyimpan nilai akhir",
                text: "Silahkan tunggu....",
                button: false,
                closeOnClickOutside: false,
                closeOnEsc: false,
                allowEscapeKey: false,
                allowOutsideClick: false,
                onOpen: () => {
                    swal.showLoading();
                }
            });
            var tbl = $('table.jexcel tr').get().map(function (row) {
                return $(row).find('td').get().map(function (cell) {
                    return $(cell).html();
                });
            });
            tbl.shift();
            tbl.shift();
            var inputs = '';
            $.each(tbl, function (idx, s) {
                var idSiswa = s[12];
                inputs += '<input type="text" name="siswa[' + idSiswa + '][id_nilai_akhir]" value="' + idMapel + idKelas + idSiswa + tpActive + smtActive + '" class="form-control col-1">';
                inputs += '<input type="text" name="siswa[' + idSiswa + '][id_siswa]" value="' + idSiswa + '" class="form-control col-1">';
                inputs += '<input type="text" name="siswa[' + idSiswa + '][id_tp]" value="' + tpActive + '" class="form-control col-1">';
                inputs += '<input type="text" name="siswa[' + idSiswa + '][id_smt]" value="' + smtActive + '" class="form-control col-1">';
                inputs += '<input type="text" name="siswa[' + idSiswa + '][id_mapel]" value="' + idMapel + '" class="form-control col-1">';
                inputs += '<input type="text" name="siswa[' + idSiswa + '][id_kelas]" value="' + idKelas + '" class="form-control col-1">';
                inputs += '<input type="text" name="siswa[' + idSiswa + '][nilai]" value="' + s[5] + '" class="form-control col-1">';
                inputs += '<input type="text" name="siswa[' + idSiswa + '][akhir]" value="' + s[6] + '" class="form-control col-1">';
                inputs += '<input type="text" name="siswa[' + idSiswa + '][predikat]" value="' + s[7] + '" class="form-control col-1">';
            });
            $('#for-upload').html(inputs);

            $.ajax({
                type: "POST",
                url: base_url + 'rapor/importpas',
                data: $(this).serialize(),
                cache: false,
                success: function (data) {
                    console.log(data);
                    swal.fire({
                        title: "Sukses",
                        html: "<b>" + data + "<b> nilai berhasil disimpan",
                        icon: "success",
                        showCancelButton: false,
                        confirmButtonColor: "#3085d6",
                        confirmButtonText: "OK"
                    }).then(result => {
                        if (result.value) {
                            window.location.href = base_url + 'rapor/inputpas/' + idMapel + '/' + idKelas
                        }
                    });
                },
                error: function (e) {
                    console.log("error", e.responseText);
                    swal.fire({
                        title: "Error",
                        html: "Gagal menyimpan",
                        icon: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#3085d6",
                        confirmButtonText: "OK"
                    })
                }
            });
        });

    });
</script>
